IF EXISTS (SELECT * FROM SYS.VIEWS
					 WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_ENTID_DOACAO]'))
	DROP VIEW [DBO].[V_EST_ENTID_DOACAO]

GO

CREATE VIEW [DBO].[V_EST_ENTID_DOACAO]
AS
	SELECT
		DOA.CD_EMP
		,DOA.CD_ENTID
		,DOA.NM_ENTID
		,EB.MSG_IMP_CUPOM_ENTID COLLATE SQL_Latin1_General_CP1_CI_AS AS MSG_IMP_CUPOM_ENTID
		,DOA.STS_ENTID
		,DOA.CD_FORN
		,FORN.CGC_CPF AS CNPJ,
		BF.CD_FILIAL
	FROM
		EST_ENTID_DOACAO DOA
		INNER JOIN PG_FORN FORN ON
			DOA.CD_EMP = FORN.CD_EMP AND
			DOA.CD_FORN = FORN.CD_FORN 
		INNER JOIN EST_ENTID_DOACAO_PRC_BANDEIRA EB ON
			DOA.CD_EMP = EB.CD_EMP AND
			DOA.CD_ENTID = EB.CD_ENTID
		INNER JOIN PRC_BANDEIRA_PRC_FILIAL BF ON
			EB.CD_EMP = BF.CD_EMP
			AND EB.CD_BANDEIRA = BF.CD_BANDEIRA
UNION

	SELECT
		DOA.CD_EMP
		,DOA.CD_ENTID
		,DOA.NM_ENTID
		,DOA.MSG_IMP_CUPOM_ENTID COLLATE SQL_Latin1_General_CP1_CI_AS AS MSG_IMP_CUPOM_ENTID
		,DOA.STS_ENTID
		,DOA.CD_FORN
		,FORN.CGC_CPF AS CNPJ,
		FIL.CD_FILIAL
	FROM
		EST_ENTID_DOACAO DOA
		INNER JOIN PG_FORN FORN ON
			DOA.CD_EMP = FORN.CD_EMP AND
			DOA.CD_FORN = FORN.CD_FORN
		INNER JOIN PRC_FILIAL FIL ON
			DOA.CD_EMP = FIL.CD_EMP
	WHERE
		NOT EXISTS (
			SELECT
				*
			FROM
				EST_ENTID_DOACAO_PRC_BANDEIRA EB
				INNER JOIN PRC_BANDEIRA_PRC_FILIAL BF ON
					EB.CD_EMP = BF.CD_EMP
					AND EB.CD_BANDEIRA = BF.CD_BANDEIRA
			WHERE
				DOA.CD_EMP = EB.CD_EMP
				AND DOA.CD_ENTID = EB.CD_ENTID
				AND FIL.CD_EMP = BF.CD_EMP
				AND FIL.CD_FILIAL = BF.CD_FILIAL)